// otData

/*
 common (generated from chapter2.htm)
 */
#import <GSFontTools/OTBase.h>
#import <GSFontTools/OTTables.h>
#import <GSFontTools/numberConversion.h>
#import <GSFontTools/table__n_a_m_e.h>

#if defined(__cplusplus)
extern "C" {
#endif /* defined(__cplusplus) */

@class OTOrderedDictionary;
@class OTAnchor;

@interface OTLookupOrder : OTBaseTable
/*
 Dummy class; this table isn't defined, but is used, and is always NULL.
 */
@end

@class OTScriptRecord;

@interface OTScriptList : OTBaseTable
@property (nonatomic, retain) NSArray<OTScriptRecord *> *scriptRecords; // Array of ScriptRecords -listed alphabetically by ScriptTag
@end

@class OTScript;

@interface OTScriptRecord : OTBaseTable
@property (nonatomic, retain) OTScript *script;
@property (nonatomic, retain) NSString *scriptTag;
@end

@class OTLangSys;
@class OTDefaultLangSys;
@class OTLangSysRecord;

@interface OTScript : OTBaseTable
@property (nonatomic, retain) OTDefaultLangSys *defaultLangSys;
@property (nonatomic, retain) NSArray<OTLangSysRecord *> *langSysRecords; // Array of LangSysRecords-listed alphabetically by LangSysTag
@end

@class OTLangSys;

@interface OTLangSysRecord : OTBaseTable
@property (nonatomic, retain) NSString *langSysTag; // 4-byte LangSysTag identifier
@property (nonatomic, retain) OTLangSys *langSys;
@end

@interface OTLangSys : OTBaseTable
@property (nonatomic, retain) NSArray<OTLookupOrder *> *lookupOrder;
@property (nonatomic) uint16_t reqFeatureIndex;
@property (nonatomic, retain) NSIndexSet *featureIndexes;
@end

@interface OTDefaultLangSys : OTLangSys
@end

@class OTFeatureParams;

@interface OTFeature : OTBaseTable
@property (nonatomic, retain) OTFeatureParams *featureParams;
@property (nonatomic, retain) NSIndexSet *lookupListIndexes;
@end

@interface OTFeatureRecord : OTBaseTable
@property (nonatomic, retain) NSString *featureTag;
@property (nonatomic, retain) OTFeature *feature;
@end

@interface OTFeatureList : OTBaseTable
@property (nonatomic, retain) NSArray<OTFeatureRecord *> *featureRecords;
@end

typedef NS_ENUM(uint8_t, GSLookupType) {
	GSLookupTypeSingle = 1,			 // Single (format 1.1 1.2)	Replace one glyph with one glyph
	GSLookupTypeMultiple = 2,		 // Multiple (format 2.1)	Replace one glyph with more than one glyph
	GSLookupTypeAlternate = 3,		 // Alternate (format 3.1)	Replace one glyph with one of many glyphs
	GSLookupTypeLigature = 4,		 // Ligature (format 4.1)	Replace multiple glyphs with one glyph
	GSLookupTypeContext = 5,		 // Context (format 5.1 5.2 5.3)	Replace one or more glyphs in context
	GSLookupTypeChainingContext = 6, // Chaining Context (format 6.1 6.2 6.3)	Replace one or more glyphs in chained context
	GSLookupTypeExtension = 7,		 // Extension Substitution (format 7.1)	Extension mechanism for other substitutions
	GSLookupTypeReverseChaining = 8, // Reverse chaining context single (format 8.1)

	GSLookupTypeSingleAdjustment = 1,		  // Adjust position of a single glyph
	GSLookupTypePairAdjustment = 2,			  // Adjust position of a pair of glyphs
	GSLookupTypeCursiveAttachment = 3,		  // Attach cursive glyphs
	GSLookupTypeMarkToBaseAttachment = 4,	  // Attach a combining mark to a base glyph
	GSLookupTypeMarkToLigatureAttachment = 5, // Attach a combining mark to a ligature
	GSLookupTypeMarkToMarkAttachment = 6,	  // Attach a combining mark to another mark
	GSLookupTypeContextPositioning = 7,		  // Position one or more glyphs in context
	GSLookupTypeChainedContext = 8,			  // positioning	Position one or more glyphs in chained context
	GSLookupTypeExtensionPositioning = 9,	  // Extension mechanism for other positionings
};

// GSUB
extern NSString *GSLookupTypeSingleKey;
extern NSString *GSLookupTypeMultipleKey;
extern NSString *GSLookupTypeAlternateKey;
extern NSString *GSLookupTypeLigatureKey;
extern NSString *GSLookupTypeContextKey;
extern NSString *GSLookupTypeChainingContextKey;
extern NSString *GSLookupTypeExtensionKey;
extern NSString *GSLookupTypeReverseChainingKey;
// GPOS
extern NSString *GSLookupTypeSingleAdjustmentKey;
extern NSString *GSLookupTypePairAdjustmentKey;
extern NSString *GSLookupTypeCursiveAttachmentKey;
extern NSString *GSLookupTypeMarkToBaseAttachmentKey;
extern NSString *GSLookupTypeMarkToLigatureAttachmentKey;
extern NSString *GSLookupTypeMarkToMarkAttachmentKey;
extern NSString *GSLookupTypeContextPositioningKey;
extern NSString *GSLookupTypeChainedContextKey;
extern NSString *GSLookupTypeExtensionPositioningKey;

GSLookupType GSLookUpTypeKeyToType(NSString *typeKey);
NSString *GSLookUpTypeGSUBToKey(GSLookupType type);
NSString *GSLookUpTypeGPOSToKey(GSLookupType type);

@class OTLookup;

@interface OTLookupList : OTBaseTable
@property (nonatomic, retain) NSArray<OTLookup *> *lookups;
- (void)addLookup:(OTLookup *)lookup;
- (NSUInteger)indexOfObjectInLookups:(OTLookup *)lookup;
@end

@interface OTLookup : OTBaseTable
@property (nonatomic) NSUInteger lookupType;
@property (nonatomic) OTLookupFlag lookupFlag;
@property (nonatomic, retain) NSArray *subTables;
@property (nonatomic) NSUInteger markFilteringSet;

- (void)setTableType:(NSString *)tableType;
@end

@interface OTFeatureParams : OTBaseTable
@end

@interface OTFeatureParamsSize : OTFeatureParams
@property (nonatomic) CGFloat designSize;
@property (nonatomic) GSNameIdNames subfamilyID;
@property (nonatomic) GSNameIdNames subfamilyNameID;
@property (nonatomic) CGFloat rangeStart;
@property (nonatomic) CGFloat rangeEnd;
@end

@interface OTFeatureParamsStylisticSet : OTFeatureParams
@property (nonatomic) uint16_t version;
@property (nonatomic) uint16_t UINameID;
@end

@interface OTFeatureParamsCharacterVariants : OTFeatureParams
@property (nonatomic) NSInteger format; // format actually used here (as opposed to other params tables)
@property (nonatomic) GSNameIdNames featUILabelNameID;
@property (nonatomic) GSNameIdNames featUITooltipTextNameID;
@property (nonatomic) GSNameIdNames sampleTextNameID;
@property (nonatomic) uint16_t numNamedParameters;
@property (nonatomic) GSNameIdNames firstParamUILabelNameID;
@property (nonatomic) uint16_t charCount;
@property (nonatomic, strong) NSArray *character;
@end

@class OTRangeRecord;

@interface OTCoverage : OTFormatSwitchingBaseTable

@property (nonatomic, retain) NSMutableArray *glyphNames; // always set, even if setting range records directly
														  // It's assumed in various places and rebuilding the glyph names inside a property getter won't do
														  // as there's no access there to the parent font object's glyph names (if they're set in the first place).
@property (nonatomic, retain) NSArray<OTRangeRecord *> *rangeRecords;

- (NSUInteger)count;

@end

@interface OTMarkCoverage : OTCoverage
@end

@interface OTBaseCoverage : OTCoverage
@end

@interface OTLigatureCoverage : OTCoverage
@end

@interface OTMark1Coverage : OTCoverage
@end

@interface OTMark2Coverage : OTCoverage
@end

@interface OTBacktrackCoverage : OTCoverage
@end

@interface OTInputCoverage : OTCoverage
@end

@interface OTLookAheadCoverage : OTCoverage
@end

@interface OTVertGlyphCoverage : OTCoverage
@end

@interface OTHorizGlyphCoverage : OTCoverage
@end

@interface OTTopAccentCoverage : OTCoverage
@end

@interface OTExtendedShapeCoverage : OTCoverage
@end

@interface OTMathKernCoverage : OTCoverage
@end

@interface OTDeltaSetIndexMap : OTFormatSwitchingBaseTable

@property (strong) NSMutableArray *mapping;

@end

@interface OTRangeRecord : OTBaseTable
@property (nonatomic) NSUInteger start;
@property (nonatomic) NSUInteger end;
@property (nonatomic) uint16_t startCoverageIndex;
@end

@class OTClassRangeRecord;

@interface OTClassDef : OTFormatSwitchingBaseTable
@property (nonatomic, assign) NSUInteger startGlyph;
@property (nonatomic, retain) NSArray<NSNumber *> *classValues;
@property (nonatomic, retain) NSArray<OTClassRangeRecord *> *classRangeRecords;
@property (nonatomic, retain) NSString *tagName;

- (NSDictionary *)classDefs;																	   // deprecated: available only on load as read-only; use -getClassDefsForGlyphOrder: if possible
- (NSDictionary *)getClassDefsForGlyphOrder:(NSArray<NSString *> *)glyphOrder NS_RETURNS_RETAINED; // the high-level class defs require glyph names

@property (nonatomic, retain) NSArray<NSIndexSet *> *classIndexSets;

- (NSNumber *)classForGlyphName:(NSString *)glyphName;

@end

@interface OTGlyphClassDef : OTClassDef
@end

@interface OTClassDef1 : OTClassDef
@end

@interface OTClassDef2 : OTClassDef
@end

@interface OTBacktrackClassDef : OTClassDef
@end

@interface OTInputClassDef : OTClassDef
@end

@interface OTLookAheadClassDef : OTClassDef
@end

@interface OTMarkAttachClassDef : OTClassDef
@end

@interface OTClassRangeRecord : OTBaseTable
@property (nonatomic) uint16_t start;
@property (nonatomic) uint16_t end;
@property (nonatomic, assign) uint16_t classID;
@end

@interface OTMarkGlyphSetsDef : OTBaseTable
@property (nonatomic) uint16_t markSetTableFormat;
@property (nonatomic, retain) NSArray<OTCoverage *> *coverage;
@end

@interface OTDevice : OTBaseTable
@property (nonatomic) uint16_t startSize;
@property (nonatomic) uint16_t endSize;
@property (nonatomic) uint16_t deltaFormat;
@property (nonatomic, retain) NSArray *deltaValues;
@end

@interface OTXDeviceTable : OTDevice
@end

@interface OTYDeviceTable : OTDevice
@end


#pragma mark -
#pragma mark GPOS (generated from gpos.htm)

@class OTFeatureVariations;

@interface OTGPOS : OTBaseTable
@property (nonatomic, retain) OTScriptList *scriptList;
@property (nonatomic, retain) OTLookupList *lookupList;
@property (nonatomic, retain) OTFeatureList *featureList;
@property (nonatomic, retain) OTFeatureVariations *featureVariations;
@property uint16_t majorVersion;
@property uint16_t minorVersion;

- (OTLookup *)lookupAtIndex:(NSUInteger)idx;
- (NSString *)fdkFeatureCodeForFeature:(NSString *)featureTag lookups:(NSMutableDictionary *)lookups;
@end

@interface OTSinglePos : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTCoverage *coverage;	 // Offset to Coverage table-from beginning of SinglePos subtable
@property (nonatomic) uint16_t valueFormat;			 // Defines the types of data in the ValueRecord
@property (nonatomic, retain) OTValueRecord *value;	 // Defines positioning value(s)-applied to all glyphs in the Coverage table
@property (nonatomic, retain) NSArray<OTValueRecord *> *valueRecords; // Array of ValueRecords-positioning values applied to glyphs
@end

@class OTPairSet;
@class OTClass1Record;

@interface OTPairPos : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTCoverage *coverage;
@property (nonatomic, retain) NSArray<OTPairSet *> *pairSets;	 // Array of PairSets tables
@property (nonatomic, retain) OTClassDef *classDef1; // Offset to ClassDef table-from beginning of PairPos subtable-for the first glyph of the pair
@property (nonatomic, retain) OTClassDef *classDef2; // Offset to ClassDef table-from beginning of PairPos subtable-for the second glyph of the pair
@property (nonatomic) uint16_t class2Count;
@property (nonatomic, retain) NSArray<OTClass1Record *> *class1Records; // Array of Class1 records-ordered by Class1
@property (nonatomic) uint16_t valueFormat1;		  // Defines the types of data in ValueRecord1-for the first glyph in the pair -may be zero (0)
@property (nonatomic) uint16_t valueFormat2;		  // Defines the types of data in ValueRecord2-for the second glyph in the pair -may be zero (0)
@end

@interface OTPairSet : OTBaseTable
@property (nonatomic, retain) NSArray *pairValueRecords; // Array of PairValueRecords-ordered by GlyphID of the second glyph
@end

@interface OTPairValueRecord : OTBaseTable
@property (nonatomic, retain) OTValueRecord *value1; // Positioning data for the first glyph in the pair
@property (nonatomic, retain) OTValueRecord *value2; // Positioning data for the second glyph in the pair
@property (nonatomic, retain) NSString *secondGlyph; // GlyphName of second glyph in the pair-first glyph is listed in the Coverage table
@end

@interface OTClass1Record : OTBaseTable
@property (nonatomic, retain) NSArray *class2Records; // Array of Class2 records-ordered by Class2
@end

@interface OTClass2Record : OTBaseTable
@property (nonatomic, retain) OTValueRecord *value1; // Positioning for first glyph; empty if ValueFormat1 = 0
@property (nonatomic, retain) OTValueRecord *value2; // Positioning for second glyph; empty if ValueFormat2 = 0
@end

@interface OTEntryExitRecord : OTBaseTable
@property (nonatomic, retain) OTAnchor *entryAnchor; // Offset to EntryAnchor table-from beginning of CursivePos subtable-may be NULL
@property (nonatomic, retain) OTAnchor *exitAnchor;	 // Offset to ExitAnchor table-from beginning of CursivePos subtable-may be NULL
@end

@interface OTCursivePos : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTCoverage *coverage;
@property (nonatomic, retain) NSArray<OTEntryExitRecord *> *entryExitRecords;
@end

@class OTBaseRecord;

@interface OTBaseArray : OTBaseTable
@property (nonatomic, retain) NSArray<OTBaseRecord *> *baseRecords; // Array of BaseRecords-in order of BaseCoverage Index
@end

@class OTMarkRecord;

@interface OTMarkArray : OTBaseTable
@property (nonatomic, retain) NSArray<OTMarkRecord *> *markRecords; // Array of MarkRecords-in Coverage order
@end

@interface OTMarkBasePos : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTCoverage *markCoverage; // Offset to MarkCoverage table-from beginning of MarkBasePos subtable
@property (nonatomic, retain) OTCoverage *baseCoverage; // Offset to BaseCoverage table-from beginning of MarkBasePos subtable
@property (nonatomic) uint16_t classCount;				// Number of classes defined for marks
@property (nonatomic, retain) OTMarkArray *markArray;	// Offset to MarkArray table-from beginning of MarkBasePos subtable
@property (nonatomic, retain) OTBaseArray *baseArray;	// Offset to BaseArray table-from beginning of MarkBasePos subtable
@end

@class OTBaseAnchor;

@interface OTBaseRecord : OTBaseTable
@property (nonatomic, retain) NSArray<OTBaseAnchor *> *baseAnchors; // Array of offsets (one per class) to Anchor tables-from beginning of BaseArray table-ordered by class-zero-based
@end

@interface OTMark1Array : OTMarkArray
@end

@interface OTMarkRecord : OTBaseTable
@property (nonatomic) uint16_t classID;				// Class defined for this mark
@property (nonatomic, retain) OTAnchor *markAnchor; // Offset to Anchor table-from beginning of MarkArray table
@end

@class OTLigatureArray;

@interface OTMarkLigPos : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTCoverage *markCoverage;		  // Offset to Mark Coverage table-from beginning of MarkLigPos subtable
@property (nonatomic, retain) OTCoverage *ligatureCoverage;	  // Offset to Ligature Coverage table-from beginning of MarkLigPos subtable
@property (nonatomic) uint16_t classCount;					  // Number of defined mark classes
@property (nonatomic, retain) OTMarkArray *markArray;		  // Offset to MarkArray table-from beginning of MarkLigPos subtable
@property (nonatomic, retain) OTLigatureArray *ligatureArray; // Offset to LigatureArray table-from beginning of MarkLigPos subtable
@end

@class OTLigatureAttach;

@interface OTLigatureArray : OTBaseTable
@property (nonatomic, retain) NSArray<OTLigatureAttach *> *ligatureAttachs; // Array of offsets to LigatureAttach tables-from beginning of LigatureArray table-ordered by LigatureCoverage Index
@end

@class OTComponentRecord;

@interface OTLigatureAttach : OTBaseTable
@property (nonatomic, retain) NSArray<OTComponentRecord *> *componentRecords; // Array of Component records-ordered in writing direction
@end

@class OTLigatureAnchor;

@interface OTComponentRecord : OTBaseTable
@property (nonatomic, retain) NSArray<OTLigatureAnchor *> *ligatureAnchors; // Array of offsets (one per class) to Anchor tables-from beginning of LigatureAttach table-ordered by class-NULL if a component does not have an attachment for a class-zero-based array
@end

@class OTMark2Record;

@interface OTMark2Array : OTBaseTable
@property (nonatomic, retain) NSArray<OTMark2Record *> *mark2Records; // Array of Mark2 records-in Coverage order
@end

@interface OTMarkMarkPos : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTCoverage *mark1Coverage; // Offset to Combining Mark Coverage table-from beginning of MarkMarkPos subtable
@property (nonatomic, retain) OTCoverage *mark2Coverage; // Offset to Base Mark Coverage table-from beginning of MarkMarkPos subtable
@property (nonatomic) uint16_t classCount;				 // Number of Combining Mark classes defined
@property (nonatomic, retain) OTMark1Array *mark1Array;	 // Offset to MarkArray table for Mark1-from beginning of MarkMarkPos subtable
@property (nonatomic, retain) OTMark2Array *mark2Array;	 // Offset to Mark2Array table for Mark2-from beginning of MarkMarkPos subtable
@end

@class OTMark2Anchor;

@interface OTMark2Record : OTBaseTable
@property (nonatomic, retain) NSArray<OTMark2Anchor *> *mark2Anchors; // Array of offsets (one per class) to Anchor tables-from beginning of Mark2Array table-zero-based array
@end

@interface OTPosLookupRecord : OTBaseTable
@property (nonatomic) uint16_t sequenceIndex; // Index to input glyph sequence-first glyph = 0
@property (nonatomic) uint16_t lookupListIndex;	  // Lookup to apply to that position-zero-based
@end

@class OTPosRuleSet;
@class OTPosClassSet;

@interface OTContextPos : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTCoverage *coverage; // Offset to Coverage table-from beginning of ContextPos subtable
@property (nonatomic, retain) NSArray<OTCoverage *> *coverages;
@property (nonatomic, retain) NSArray<OTPosRuleSet *> *posRuleSets;		 // Array of offsets to PosRuleSet tables-from beginning of ContextPos subtable-ordered by Coverage Index
@property (nonatomic, retain) OTClassDef *classDef;		 // Offset to ClassDef table-from beginning of ContextPos subtable
@property (nonatomic, retain) NSArray<OTPosClassSet *> *posClassSets;	 // Array of offsets to PosClassSet tables-from beginning of ContextPos subtable-ordered by class-may be NULL
@property (nonatomic, retain) NSArray<OTPosLookupRecord *> *posLookupRecords; // Array of positioning lookups-in design order
@end

@class OTPosRule;

@interface OTPosRuleSet : OTBaseTable
@property (nonatomic, retain) NSArray<OTPosRule *> *posRules; // Array of offsets to PosRule tables-from beginning of PosRuleSet-ordered by preference
@end

@interface OTPosRule : OTBaseTable
@property (nonatomic, retain) NSArray<NSString *> *inputs;			 //-1, 'Array of input glyph names-starting with the second glyph
@property (nonatomic, retain) NSArray<OTPosLookupRecord *> *posLookupRecords; // Array of positioning lookups-in design order
@end

@class OTPosClassRule;

@interface OTPosClassSet : OTBaseTable
@property (nonatomic, retain) NSArray<OTPosClassRule *> *posClassRules; // Array of offsets to PosClassRule tables-from beginning of PosClassSet-ordered by preference
@end

@interface OTPosClassRule : OTBaseTable
@property (nonatomic, retain) NSArray<NSNumber *> *classIDs;		 //-1, 'Array of classes-beginning with the second class-to be matched to the input glyph sequence
@property (nonatomic, retain) NSArray<OTPosLookupRecord *> *posLookupRecords; // Array of positioning lookups-in design order
@end

@class OTChainPosRuleSet;

@interface OTChainContextPos : OTFormatSwitchingBaseTable
// Format 1
@property (nonatomic, retain) OTCoverage *coverage;		 // Offset to coverage table-from beginning of ContextPos subtable
@property (nonatomic, retain) NSArray<OTChainPosRuleSet *> *chainPosRuleSets; // Array of offsets to ChainPosRuleSet tables-from beginning of ContextPos subtable-ordered by Coverage Index
// Format 2
@property (nonatomic, retain) OTClassDef *backtrackClassDef; // Offset to ClassDef table containing backtrack sequence context-from beginning of ChainContextPos subtable
@property (nonatomic, retain) OTClassDef *inputClassDef;	 // Offset to ClassDef table containing input sequence context-from beginning of ChainContextPos subtable
@property (nonatomic, retain) OTClassDef *lookAheadClassDef; // Offset to ClassDef table containing lookahead sequence context-from beginning of ChainContextPos subtable
@property (nonatomic, retain) NSArray *chainPosClassSets;	 // Array of offsets to ChainPosClassSet tables-from beginning of ChainContextPos subtable-ordered by input class-may be NULL
// Format 3
@property (nonatomic, retain) NSArray<OTCoverage *> *backtrackCoverages; // Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
@property (nonatomic, retain) NSArray<OTCoverage *> *inputCoverages;	   // Array of offsets to coverage tables in input sequence, in glyph sequence order
@property (nonatomic, retain) NSArray<OTCoverage *> *lookAheadCoverages; // Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
@property (nonatomic, retain) NSArray<OTPosLookupRecord *> *posLookupRecords;   // Array of PosLookupRecords,in design order
@end

@interface OTChainPosRuleSet : OTBaseTable
@property (nonatomic, retain) NSArray *chainPosRules; // Array of offsets to ChainPosRule tables-from beginning of ChainPosRuleSet-ordered by preference
@end

@interface OTChainPosRule : OTBaseTable
@property (nonatomic, retain) NSArray<NSString *> *backtracks;		 // Array of backtracking GlyphID's (to be matched before the input sequence)
@property (nonatomic, retain) NSArray<NSString *> *inputs;			 //-1, 'Array of input GlyphIDs (start with second glyph)
@property (nonatomic, retain) NSArray<NSString *> *lookAheads;		 // Array of lookahead GlyphID's (to be matched after the input sequence)
@property (nonatomic, retain) NSArray<OTPosLookupRecord *> *posLookupRecords; // Array of PosLookupRecords (in design order)
@end

@class OTChainPosClassRule;

@interface OTChainPosClassSet : OTBaseTable
@property (nonatomic, retain) NSArray<OTChainPosClassRule *> *chainPosClassRules; // Array of offsets to ChainPosClassRule tables-from beginning of ChainPosClassSet-ordered by preference
@end

@interface OTChainPosClassRule : OTBaseTable
@property (nonatomic, retain) NSArray<NSNumber *> *backtracks;		 // Array of backtracking classes(to be matched before the input sequence)
@property (nonatomic, retain) NSArray<NSNumber *> *inputs;			 //', 'InputGlyphCount', -1, 'Array of input classes(start with second class; to be matched with the input glyph sequence)
@property (nonatomic, retain) NSArray<NSNumber *> *lookAheads;		 // Array of lookahead classes(to be matched after the input sequence)
@property (nonatomic, retain) NSArray<OTPosLookupRecord *> *posLookupRecords; // Array of PosLookupRecords (in design order)
@end

@interface OTExtensionPos : OTFormatSwitchingBaseTable
@property (nonatomic) NSUInteger extensionLookupType;	// Lookup type of subtable referenced by ExtensionOffset (i.e. the extension subtable).
@property (nonatomic, retain) OTBaseTable *extSubTable; // Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
@end

/*
@interface ValueRecord_ : OTBaseTable {
@public
	int16_t XPlacement; //Horizontal adjustment for placement-in design units
	int16_t YPlacement; //Vertical adjustment for placement-in design units
	int16_t XAdvance; //Horizontal adjustment for advance-in design units (only used for horizontal writing)
	int16_t YAdvance; //Vertical adjustment for advance-in design units (only used for vertical writing)
	NSUInteger XPlaDeviceOffsets; //Offset to Device table for horizontal placement-measured from beginning of PosTable (may be NULL)
	NSUInteger YPlaDeviceOffsets; //Offset to Device table for vertical placement-measured from beginning of PosTable (may be NULL)
	NSUInteger XAdvDeviceOffsets; //Offset to Device table for horizontal advance-measured from beginning of PosTable (may be NULL)
	NSUInteger YAdvDeviceOffsets; //Offset to Device table for vertical advance-measured from beginning of PosTable (may be NULL)
}
@end
*/
@interface OTAnchor : OTFormatSwitchingBaseTable
// 1
@property (nonatomic) int16_t xCoordinate; // Horizontal value-in design units
@property (nonatomic) int16_t yCoordinate; // Vertical value-in design units
// 2
@property (nonatomic) uint16_t anchorPoint; // Index to glyph contour point
// 3
@property (nonatomic, retain) OTDevice *xDeviceTable; // Offset to Device table for X coordinate- from beginning of Anchor table (may be NULL)
@property (nonatomic, retain) OTDevice *yDeviceTable; // Offset to Device table for Y coordinate- from beginning of Anchor table (may be NULL)
@end

@interface OTEntryAnchor : OTAnchor
@end

@interface OTExitAnchor : OTAnchor
@end

@interface OTBaseAnchor : OTAnchor
@end

@interface OTLigatureAnchor : OTAnchor
@end

@interface OTMark2Anchor : OTAnchor
@end

@interface OTMarkAnchor : OTAnchor
@end
/*
@interface AnchorFormat1 : OTFormatSwitchingBaseTable {
@public
	int16_t XCoordinate; //Horizontal value-in design units
	int16_t YCoordinate; //Vertical value-in design units
}
@end


@interface AnchorFormat2 : OTFormatSwitchingBaseTable {
@public
	int16_t XCoordinate; //Horizontal value-in design units
	int16_t YCoordinate; //Vertical value-in design units
	uint16_t AnchorPoint; //Index to glyph contour point
}
@end


@interface AnchorFormat3 : OTFormatSwitchingBaseTable {
@public
	int16_t XCoordinate; //Horizontal value-in design units
	int16_t YCoordinate; //Vertical value-in design units
	NSUInteger XDeviceTableOffsets; //Offset to Device table for X coordinate- from beginning of Anchor table (may be NULL)
	NSUInteger YDeviceTableOffsets; //Offset to Device table for Y coordinate- from beginning of Anchor table (may be NULL)
}
@end
*/

//
// gsub (generated from gsub.htm)
//
@class OTFeatureVariations;

@interface OTGSUB : OTBaseTable {
	OTScriptList *_scriptList;
	OTLookupList *_lookupList;
	OTFeatureList *_featureList;
	OTFeatureVariations *_featureVariations;
	// Fixed _version; //Version of the GSUB table-initially set to 0x00010000
	uint16_t _majorVersion;
	uint16_t _minorVersion;
}

@property (nonatomic, retain) OTScriptList *scriptList;
@property (nonatomic, retain) OTLookupList *lookupList;
@property (nonatomic, retain) OTFeatureList *featureList;
@property (nonatomic, retain) OTFeatureVariations *featureVariations;
@property uint16_t majorVersion;
@property uint16_t minorVersion;

- (NSString *)fdkFeatureCodeForFeature:(NSString *)featureTag lookups:(NSMutableDictionary *)lookups;
@end

@interface OTSingleSubst : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTCoverage *coverage;
@property (nonatomic, assign) NSInteger deltaGlyphID;
@property (nonatomic, retain) NSArray *substitute;
@property (nonatomic, retain) OTOrderedDictionary *mapping;
@end

@interface OTMultipleSubst : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTCoverage *coverage;
@property (nonatomic, retain) NSArray *sequences;
@property (nonatomic, retain) OTOrderedDictionary *mapping;
@end

@interface OTSequence : OTBaseTable
@property (nonatomic, retain) NSArray *substitutes;
@end

@interface OTAlternateSubst : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTOrderedDictionary *mapping;
@property (nonatomic, retain) OTCoverage *coverage;
@property (nonatomic, retain) NSArray *alternateSets;
@end

@interface OTAlternateSet : OTBaseTable
@property (nonatomic, retain) NSArray *alternates;
@end

@interface OTLigatureSubst : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTOrderedDictionary *ligatures;
@property (nonatomic, retain) OTCoverage *coverage;
@property (nonatomic, retain) NSArray *ligatureSets;
@end

@interface OTLigature : OTBaseTable
@property (nonatomic, assign) NSString *ligGlyphName;
@property (nonatomic, retain) NSArray<NSString *> *components;
@end

@interface OTLigatureSet : OTBaseTable
@property (nonatomic, retain) NSArray *ligatures;
@end

@interface OTSubstLookupRecord : OTBaseTable
@property (nonatomic, assign) uint16_t sequenceIndex;
@property (nonatomic, assign) uint16_t lookupListIndex;
@end

@interface OTContextSubst : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTCoverage *coverage;
@property (nonatomic, retain) NSArray *coverages;
@property (nonatomic, retain) NSArray *subRuleSets;
@property (nonatomic, retain) OTClassDef *classDef;
@property (nonatomic, retain) NSArray *subClassSets;
@property (nonatomic, retain) NSArray *substLookupRecords;
@end

@interface OTSubRuleSet : OTBaseTable
@property (nonatomic, strong) NSArray *subRules;
@end

@interface OTSubRule : OTBaseTable
@property (nonatomic, strong) NSArray<NSString *> *inputs;
@property (nonatomic, strong) NSArray<OTSubstLookupRecord *> *substLookupRecords;
@property (nonatomic, readonly) NSUInteger glyphCount;
@end

@class OTSubClassRule;

@interface OTSubClassSet : OTBaseTable
@property (nonatomic, retain) NSArray<OTSubClassRule *> *subClassRules;
@end

@interface OTSubClassRule : OTBaseTable
@property (nonatomic, retain) NSArray<NSNumber *> *classIDs;
@property (nonatomic, retain) NSArray<OTSubstLookupRecord *> *substLookupRecords;
@property (nonatomic, readonly) NSUInteger glyphCount;
@end

@class OTChainSubRuleSet;
@class OTChainSubClassSet;

@interface OTChainContextSubst : OTFormatSwitchingBaseTable

@property (nonatomic, retain) OTCoverage *coverage;

@property (nonatomic, retain) NSArray<OTChainSubRuleSet *> *chainSubRuleSets;

@property (nonatomic, retain) OTClassDef *backtrackClassDef;
@property (nonatomic, retain) OTClassDef *inputClassDef;
@property (nonatomic, retain) OTClassDef *lookAheadClassDef;

@property (nonatomic, retain) NSArray<OTChainSubClassSet *> *chainSubClassSets;

@property (nonatomic, retain) NSArray<OTCoverage *> *backtrackCoverages;
@property (nonatomic, retain) NSArray<OTCoverage *> *inputCoverages;

@property (nonatomic, retain) NSArray<OTCoverage *> *lookAheadCoverages;
@property (nonatomic, retain) NSArray<OTSubstLookupRecord *> *substLookupRecords;
@end

@interface OTChainSubRule : OTBaseTable
@property (nonatomic, retain) NSArray<NSString *> *backtracks;
@property (nonatomic, retain) NSArray<NSString *> *inputs;
@property (nonatomic, retain) NSArray<NSString *> *lookAheads;
@property (nonatomic, retain) NSArray<OTSubstLookupRecord *> *substLookupRecords;
@property (nonatomic, readonly) NSUInteger inputGlyphCount;
@end

@interface OTChainSubRuleSet : OTBaseTable
@property (nonatomic, strong) NSArray<OTChainSubRule *> *chainSubRules;
@end

@class OTChainSubClassRule;

@interface OTChainSubClassSet : OTBaseTable
@property (nonatomic, retain) NSArray<OTChainSubClassRule *> *chainSubClassRules;
@end

@interface OTChainSubClassRule : OTBaseTable
@property (nonatomic, retain) NSArray<NSNumber *> *backtracks;
@property (nonatomic, retain) NSArray<NSNumber *> *inputs;
@property (nonatomic, retain) NSArray<NSNumber *> *lookAheads;
@property (nonatomic, retain) NSArray<OTSubstLookupRecord *> *substLookupRecords;
@property (nonatomic, readonly) NSUInteger inputGlyphCount;
@end

@interface OTExtensionSubst : OTFormatSwitchingBaseTable { // Lookup type 7
	NSUInteger _extensionLookupType;					   // Lookup type of subtable referenced by ExtensionOffset (i.e. the extension subtable).
	// NSArray * _extSubTableOffsets; //Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
	id _extSubTable; // Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
}
@property (nonatomic, assign) NSUInteger extensionLookupType;
@property (nonatomic, retain) id extSubTable;

@end

@interface OTReverseChainSingleSubst : OTFormatSwitchingBaseTable
@property (nonatomic, retain) OTCoverage *coverage;
@property (nonatomic, retain) NSArray<OTCoverage *> *backtrackCoverages;
@property (nonatomic, retain) NSArray<OTCoverage *> *lookAheadCoverages;
@property (nonatomic, retain) NSArray<NSString *> *substitutes;

@end

#pragma mark gdef (generated from gdef.htm)

@class OTAttachPoint;

@interface OTAttachList : OTBaseTable
@property (nonatomic, retain) NSArray<OTCoverage *> *coverage;
@property (nonatomic, retain) NSArray<OTAttachPoint *> *attachPoints;
@end

@class OTLigGlyph;

@interface OTLigCaretList : OTBaseTable
@property (nonatomic, strong) OTCoverage *coverage;
@property (nonatomic, strong) NSArray<OTLigGlyph *> *ligGlyphs;
@end

@class OTVarStore;

@interface OTGDEF : OTBaseTable
@property (nonatomic) uint16_t majorVersion;
@property (nonatomic) uint16_t minorVersion;
@property (nonatomic, retain) OTClassDef *glyphClassDef;
@property (nonatomic, retain) OTAttachList *attachList;
@property (nonatomic, retain) OTLigCaretList *ligCaretList;
@property (nonatomic, retain) OTClassDef *markAttachClassDef;
@property (nonatomic, retain) OTMarkGlyphSetsDef *markGlyphSetsDef;
@property (nonatomic, retain) OTVarStore *varStore;
@end

@interface OTAttachPoint : OTBaseTable
@property (nonatomic, retain) NSArray<NSNumber *> *pointIndexes;
@end

@interface OTCaretValue : OTFormatSwitchingBaseTable
@property (nonatomic) int16_t coordinate;
@property (nonatomic) uint16_t caretValuePoint;
@property (nonatomic, strong) OTDevice *deviceTable;
@end

@interface OTLigGlyph : OTBaseTable
@property (nonatomic, retain) NSArray<OTCaretValue *> *caretValues;
@end

#pragma mark GSUB/GPOS FeatureVariations

@interface OTConditionTable : OTFormatSwitchingBaseTable
@property (nonatomic) uint16_t axisIndex;
@property (nonatomic) F2DOT14_t filterRangeMinValue;
@property (nonatomic) F2DOT14_t filterRangeMaxValue;
@end

@interface OTConditionSet : OTBaseTable // ConditionSet
@property uint16_t conditionCount;
@property (nonatomic, retain) NSArray<OTConditionTable *> *conditionTables;
@end

@interface OTFeatureTableSubstitutionRecord : OTBaseTable // SubstitutionRecord
@property (nonatomic) uint16_t featureIndex;
@property (nonatomic, retain) OTFeature *feature;
@end

@interface OTFeatureTableSubstitution : OTBaseTable // FeatureTableSubstitution
@property (nonatomic) uint16_t majorVersion;
@property (nonatomic) uint16_t minorVersion;
@property uint16_t substitutionCount;
@property (nonatomic, retain) NSArray<OTFeatureTableSubstitutionRecord *> *featureTableSubstitutionRecords;
@end

@interface OTFeatureVariationRecord : OTBaseTable // FeatureVariationRecord
@property (nonatomic, retain) OTConditionSet *conditionSet;
@property (nonatomic, retain) OTFeatureTableSubstitution *featureTableSubstitution;
@end

@interface OTFeatureVariations : OTBaseTable // FeatureVariations
@property (nonatomic) uint16_t majorVersion;
@property (nonatomic) uint16_t minorVersion;
@property (nonatomic, retain) NSArray<OTFeatureVariationRecord *> *featureVariationRecords;
@end

#pragma mark VariationStore

@interface OTVarRegionAxis : OTBaseTable
@property (assign) CGFloat startCoord;
@property (assign) CGFloat peakCoord;
@property (assign) CGFloat endCoord;
@end

@interface OTVarRegion : OTBaseTable
@property (strong) NSArray<OTVarRegionAxis *> *varRegionAxis;
@end

@interface OTVarRegionList : OTBaseTable
@property (assign) uint16_t regionAxisCount;
@property (strong) NSArray<OTVarRegion *> *regions;
@end

@interface OTVarIdxMap : OTBaseTable
@property (assign) uint16_t entryFormat;
@property (assign) uint16_t mappingCount;
@property (assign) NSMutableArray *mapping;
@end

@interface OTVarData : OTBaseTable
//@property (assign) uint16_t itemCount;
@property (assign) uint16_t numShorts;
@property (strong) NSArray<NSNumber *> *varRegionIndex;
@property (strong) NSArray<NSArray<NSNumber *> *> *items;
@end

@interface OTVarStore : OTBaseTable
@property (strong) OTVarRegionList *varRegionList;
@property (strong) NSArray<OTVarData *> *varDatas;
@end

#pragma mark -
#pragma mark MVAR
@interface OTMetricsValueRecord : OTBaseTable {
	NSString *_valueTag; // 4-byte font-wide measure identifier'),
	uint16_t _deltaSetOuterIndex;
	uint16_t _deltaSetInnerIndex;
	char *_moreBytes; // ValueRecordSize', -8, 'Extra bytes.  Set to empty array.'),
}
@end

@interface OTMVAR : OTBaseTable
@property (nonatomic) uint16_t majorVersion;
@property (nonatomic) uint16_t minorVersion;
@property (nonatomic) uint16 axisCount;
@property (nonatomic) uint16 valueRecordSize;
@property (nonatomic) uint16 valueRecordCount;
@property (nonatomic) NSUInteger varStore;
@property (nonatomic, strong) NSArray<OTMetricsValueRecord *> *valueRecords;
@end

#pragma mark -
#pragma mark HVAR

@interface OTHVAR : OTBaseTable
@property (assign) uint16 majorVersion;
@property (assign) uint16 minorVersion;
@property (strong) OTVarStore *varStore;
@property (strong) OTVarIdxMap *advWidthMap;
@property (strong) OTVarIdxMap *lsbMap;
@property (strong) OTVarIdxMap *rsbMap;
@end

#pragma mark -
#pragma mark VVAR

@interface OTVVAR : OTBaseTable
@property (assign) uint16 majorVersion;
@property (assign) uint16 minorVersion;
@property (strong) OTVarStore *varStore;
@property (strong) OTVarIdxMap *advHeightMap;
@property (strong) OTVarIdxMap *tsbMap;
@property (strong) OTVarIdxMap *bsbMap;
@property (strong) OTVarIdxMap *vOrgMap;
@end

#pragma mark -
#pragma mark base (generated from base.htm)

@interface BASE : OTBaseTable {
  @public
	/*fixed32*/ uint32_t Version; // Version of the BASE table-initially 0x00010000
	NSUInteger HorizAxisOffsets;  // Offset to horizontal Axis table-from beginning of BASE table-may be NULL
	NSUInteger VertAxisOffsets;	  // Offset to vertical Axis table-from beginning of BASE table-may be NULL
}
@end

@interface Axis : OTBaseTable {
  @public
	NSUInteger BaseTagListOffsets;	  // Offset to BaseTagList table-from beginning of Axis table-may be NULL
	NSUInteger BaseScriptListOffsets; // Offset to BaseScriptList table-from beginning of Axis table
}
@end

@interface BaseTagList : OTBaseTable {
  @public
	uint16_t BaseTagCount; // Number of baseline identification tags in this text direction-may be zero (0)
	NSArray *BaselineTags; // Array of 4-byte baseline identification tags-must be in alphabetical order
}
@end

@interface BaseScriptList : OTBaseTable {
  @public
	uint16_t BaseScriptCount;	// Number of BaseScriptRecords defined
	NSArray *BaseScriptRecords; // Array of BaseScriptRecords-in alphabetical order by BaseScriptTag
}
@end

@interface BaseScriptRecord : OTBaseTable {
  @public
	NSString *BaseScriptTag;	  // 4-byte script identification tag
	NSUInteger BaseScriptOffsets; // Offset to BaseScript table-from beginning of BaseScriptList
}
@end

@interface BaseScript : OTBaseTable {
  @public
	NSUInteger BaseValueOffsets;	 // Offset to BaseValues table-from beginning of BaseScript table-may be NULL
	NSUInteger DefaultMinMaxOffsets; // Offset to MinMax table- from beginning of BaseScript table-may be NULL
	uint16_t BaseLangSysCount;		 // Number of BaseLangSysRecords defined-may be zero (0)
	NSArray *BaseLangSysRecords;	 // Array of BaseLangSysRecords-in alphabetical order by BaseLangSysTag
}
@end

@interface BaseLangSysRecord : OTBaseTable {
  @public
	NSString *BaseLangSysTag; // 4-byte language system identification tag
	NSUInteger MinMaxOffsets; // Offset to MinMax table-from beginning of BaseScript table
}
@end

@interface BaseValues : OTBaseTable {
  @public
	uint16_t DefaultIndex;	   // Index number of default baseline for this script-equals index position of baseline tag in BaselineArray of the BaseTagList
	uint16_t BaseCoordCount;   // Number of BaseCoord tables defined-should equal BaseTagCount in the BaseTagList
	NSArray *BaseCoordOffsets; // Array of offsets to BaseCoord-from beginning of BaseValues table-order matches BaselineTag array in the BaseTagList
}
@end

@interface MinMax : OTBaseTable {
  @public
	NSUInteger MinCoordOffsets; // Offset to BaseCoord table-defines minimum extent value-from the beginning of MinMax table-may be NULL
	NSUInteger MaxCoordOffsets; // Offset to BaseCoord table-defines maximum extent value-from the beginning of MinMax table-may be NULL
	uint16_t FeatMinMaxCount;	// Number of FeatMinMaxRecords-may be zero (0)
	NSArray *FeatMinMaxRecords; // Array of FeatMinMaxRecords-in alphabetical order, by FeatureTableTag
}
@end

@interface FeatMinMaxRecord : OTBaseTable {
  @public
	NSString *FeatureTableTag;	// 4-byte feature identification tag-must match FeatureTag in FeatureList
	NSUInteger MinCoordOffsets; // Offset to BaseCoord table-defines minimum extent value-from beginning of MinMax table-may be NULL
	NSUInteger MaxCoordOffsets; // Offset to BaseCoord table-defines maximum extent value-from beginning of MinMax table-may be NULL
}
@end

@interface BaseCoord : OTFormatSwitchingBaseTable {
	int16_t Coordinate;		   // X or Y value, in design units
	NSUInteger ReferenceGlyph; // GlyphID of control glyph
	uint16_t BaseCoordPoint;   // Index of contour point on the ReferenceGlyph

	NSUInteger DeviceTableOffsets; // Offset to Device table for X or Y value
}
@end

//@interface BaseCoordFormat1 : BaseCoord {}
//@end
//
//
//@interface BaseCoordFormat2 : BaseCoord {
//@public
//	NSUInteger ReferenceGlyph; //GlyphID of control glyph
//	uint16_t BaseCoordPoint; //Index of contour point on the ReferenceGlyph
//}
//@end

//@interface BaseCoordFormat3 : BaseCoord {
//@public
//	NSUInteger DeviceTableOffsets; //Offset to Device table for X or Y value
//}
//@end

#pragma mark -
#pragma mark jstf (generated from jstf.htm)

@interface JSTF : OTBaseTable {
  @public
	Fixed /*fixed32*/ Version;	// Version of the JSTF table-initially set to 0x00010000
	uint16_t JstfScriptCount;	// Number of JstfScriptRecords in this table
	NSArray *JstfScriptRecords; // Array of JstfScriptRecords-in alphabetical order, by JstfScriptTag
}
@end

@interface JstfScriptRecord : OTBaseTable {
  @public
	NSString *JstfScriptTag;	  // 4-byte JstfScript identification
	NSUInteger JstfScriptOffsets; // Offset to JstfScript table-from beginning of JSTF Header
}
@end

@interface JstfScript : OTBaseTable {
  @public
	NSUInteger ExtenderGlyphOffsets;  // Offset to ExtenderGlyph table-from beginning of JstfScript table-may be NULL
	NSUInteger DefJstfLangSysOffsets; // Offset to Default JstfLangSys table-from beginning of JstfScript table-may be NULL
	uint16_t JstfLangSysCount;		  // Number of JstfLangSysRecords in this table- may be zero (0)
	NSArray *JstfLangSysRecords;	  // Array of JstfLangSysRecords-in alphabetical order, by JstfLangSysTag
}
@end

@interface JstfLangSysRecord : OTBaseTable {
  @public
	NSString *JstfLangSysTag;	   // 4-byte JstfLangSys identifier
	NSUInteger JstfLangSysOffsets; // Offset to JstfLangSys table-from beginning of JstfScript table
}
@end

@interface ExtenderGlyph : OTBaseTable {
  @public
	uint16_t GlyphCount;	   // Number of Extender Glyphs in this script
	NSArray *ExtenderGlyphIDs; // GlyphIDs-in increasing numerical order
}
@end

@interface JstfLangSys : OTBaseTable {
  @public
	uint16_t JstfPriorityCount;	  // Number of JstfPriority tables
	NSArray *JstfPriorityOffsets; // Array of offsets to JstfPriority tables-from beginning of JstfLangSys table-in priority order
}
@end

@interface JstfPriority : OTBaseTable {
  @public
	NSUInteger ShrinkageEnableGSUBOffsets;	// Offset to Shrinkage Enable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageDisableGSUBOffsets; // Offset to Shrinkage Disable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageEnableGPOSOffsets;	// Offset to Shrinkage Enable JstfGPOSModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageDisableGPOSOffsets; // Offset to Shrinkage Disable JstfGPOSModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageJstfMaxOffsets;		// Offset to Shrinkage JstfMax table-from beginning of JstfPriority table -may be NULL
	NSUInteger ExtensionEnableGSUBOffsets;	// Offset to Extension Enable JstfGSUBModList table-may be NULL
	NSUInteger ExtensionDisableGSUBOffsets; // Offset to Extension Disable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ExtensionEnableGPOSOffsets;	// Offset to Extension Enable JstfGSUBModList table-may be NULL
	NSUInteger ExtensionDisableGPOSOffsets; // Offset to Extension Disable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ExtensionJstfMaxOffsets;		// Offset to Extension JstfMax table-from beginning of JstfPriority table -may be NULL
}
@end

@interface JstfGSUBModList : OTBaseTable {
  @public
	uint16_t LookupCount;	   // Number of lookups for this modification
	NSArray *GSUBLookupIndexs; // Array of LookupIndex identifiers in GSUB-in increasing numerical order
}
@end

@interface JstfGPOSModList : OTBaseTable {
  @public
	uint16_t LookupCount;	   // Number of lookups for this modification
	NSArray *GPOSLookupIndexs; // Array of LookupIndex identifiers in GPOS-in increasing numerical order
}
@end

@interface JstfMax : OTBaseTable {
  @public
	uint16_t LookupCount;	// Number of lookup Indices for this modification
	NSArray *LookupOffsets; // Array of offsets to GPOS-type lookup tables-from beginning of JstfMax table-in design order
}
@end

NSInteger doModulo(NSInteger value);
// NSArray * _getGlyphsFromCoverageTable( OTCoverage * coverage);

#if defined(__cplusplus)
} // extern "C"
#endif /* defined(__cplusplus) */
